﻿var caseListing = {
    context: $(".v-case-listing"),
    initialize: function(){
        
        $(".h-caseLanguage").a4autocomplete({
            ajaxAction: a4.getProjectAction("GetLanguages", "Shared"),
            valueProperty: "Code",
            labelProperty: "Name",
            altValueField: $("#CaseLanguage"),
            required: true
        });

    },
    bindEvents: function () {        
        caseListing.context.on("click", "input[type=button]", function () {
            var caseFilter = a4.parent().browse.caseFilter;
            
            var params = {
                model: caseListing.getCaseListingObject(),
                caseFilters: caseFilter ? caseFilter : ""
            };
            
            a4.showBusyBox();
            a4.callServerMethod(a4.getProjectAction("GenerateCaseListings", "Data"), params,
                function (result) {
                    a4.hideBusyBox();
                    modalDialog.close();
                    a4.top().a4.showSuccessMessage(result.message);
                });
        });        
    },
    getCaseListingObject: function () {
        var caseListingObj = {};

        caseListingObj.ProjectId = $("#ProjectId").val();
        caseListingObj.IncludeCallHistory = $("#IncludeCallHistory").is(":checked");
        caseListingObj.IncludeOpenEnd = $("#IncludeOpenEnd").is(":checked");
        caseListingObj.AdvancedOutput = $("#AdvancedOutput").is(":checked");
        caseListingObj.CaseListingSelected = $("#CaseListingSelected option:selected").map(function () {
            return $(this).text();
        }).get().join(',');

        caseListingObj.CaseLanguage = $("#CaseLanguage").val();

        return caseListingObj;
    }
};

$(document).ready(function () {
    if (caseListing.context.length > 0) {
        caseListing.initialize();
        caseListing.bindEvents();
    }
});